﻿package com.java24hours;

import java.io.*;
import java.net.*;
import java.nio.file.*;
import jdk.incubator.http.*;

public class ImageDownloader {
    public ImageDownloader() {
        String uri = "http://workbench.cadenhead.org/media/lighthouse.jpg";
        try {
            load(uri);
        } catch (URISyntaxException oops) {
            System.out.println("Złe URI: " + oops.getMessage());
        } catch (IOException | InterruptedException oops) {
            System.out.println("Błąd: " + oops.getMessage());
        }
    }
    
    public void load(String imageUri) throws URISyntaxException, IOException,
        InterruptedException {
        
            // Utwórz klienta sieciowego.
            HttpClient browser = HttpClient.newHttpClient();
            // Zbuduj żądanie dotyczące obrazu.
            URI uri = new URI(imageUri);
            HttpRequest.Builder bob = HttpRequest.newBuilder(uri);
            HttpRequest request = bob.build();
            // Utwórz plik dla pobieranego obrazu.
            Path temp = Files.createTempFile("lighthouse", ".jpg");
            // Wyślij żądanie i odbierz odpowiedź.
            HttpResponse<Path> response = browser.send(request,
                HttpResponse.BodyHandler.asFile(temp));
            System.out.println("Obraz zapisano tymczasowo w pliku "
                + temp.toFile().getAbsolutePath());
            // Zamień plik tymczasowy na stały.
            File perm = new File("lighthouse.jpg");
            temp.toFile().renameTo(perm);            
            System.out.println("Obraz przeniesiono do " + perm.getAbsolutePath());
    }
    
    public static void main(String[] arguments) {
        new ImageDownloader();
    }
}
